(function () {
    let app = angular.module('contract', []);

    app.directive('contract', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/contract.html',
            controller: function ($rootScope, $scope, $parse, $attrs) {
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;
                $scope.ContractTypes = ContractTypes;
                let contract = $parse($attrs.ngContract)($scope);
                $scope.hideActions = $parse($attrs.ngHideActions)($scope);

                ctrl.getComponentsPopover = jobInfo => {
                    let lines = [];

                    jobInfo.stacks.forEach(stack => {
                        lines.push(`<component class="small" ${!stack.isAvailableInInventory ? 'disabled="disabled"' : null}>
                                        <div class="${ stack.component.cssClasses}">
                                            <i class="fa ${stack.component.icon}"></i>
                                            <span>${ stack.component.name }</span>
                                            <div class="stackAmount">${ stack.amount }</div>
                                        </div>
                                    </component>`);
                    });

                    return `<div class="componentLine">${ _.join(lines, '') }</div>`;
                };

                ctrl.cancelContract = (contractInfo) => {
                    $rootScope.confirm(Helpers.GetLocalized('are_you_sure'),
                        Helpers.GetLocalized('cancel_contract_confirm', { cancellationfee: numeral(contractInfo.cancellationFee).format(Configuration.CURRENCY_FORMAT) }),
                        () => {
                            Helpers.CancelContract(contractInfo.contract);
                            Game.Lifecycle._update(0);
                        });
                };

                ctrl.deliverContract = (contractInfo) => {
                    DeliverContract(contractInfo.contract);
                    Game.Lifecycle._update(0);
                    $scope.$broadcast(GameEvents.ContractChange);
                };

                let updateContract = () => {
                    let stacks = Helpers.ConvertRequirementsIntoStacks(contract.requirements);
                    $scope.contractInfo = {
                        order: 1,
                        contract: contract,
                        stacks: stacks,
                        totalComponents: _.sum(_.toArray(contract.requirements)),
                        isReadyForDelivery: stacks.every(stack => stack.isAvailableInInventory),
                        pastDueFee: Helpers.CalculatePastDueFee(contract),
                        cancellationFee: Helpers.CalculateCancellationFee(contract),
                        product: CompetitorProducts.find(x => x.id == contract.productId),
                        offer: {
                            pricePerHour: $rootScope.settings.lastPricePerHour || 150
                        }
                    }
                };

                $scope.$on(GameEvents.InventoryChange, () => updateContract());
                $scope.$on(GameEvents.OnNewHour, () => updateContract());
                updateContract();
            },
            controllerAs: 'contractCtrl'
        };
    });
})();
